/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.net.bytebuddy.matcher;

import com.comphenix.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import com.comphenix.net.bytebuddy.description.ByteCodeElement;
import com.comphenix.net.bytebuddy.description.type.TypeDescription;
import com.comphenix.net.bytebuddy.matcher.ElementMatcher;
import com.comphenix.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@HashCodeAndEqualsPlugin.Enhance
public class AccessibilityMatcher<T extends ByteCodeElement>
extends ElementMatcher.Junction.ForNonNullValues<T> {
    private final TypeDescription typeDescription;

    public AccessibilityMatcher(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    @Override
    protected boolean doMatch(T target) {
        return target.isAccessibleTo(this.typeDescription);
    }

    public String toString() {
        return "isAccessibleTo(" + this.typeDescription + ")";
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeDescription.equals(((AccessibilityMatcher)object).typeDescription);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.typeDescription.hashCode();
    }
}

